/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.dischargelamps.quantum.model;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.quantum.model.ElectromotiveForce;
import edu.colorado.phet.dischargelamps.quantum.model.Electrode;
import edu.colorado.phet.dischargelamps.quantum.model.Electron;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSink;
import edu.colorado.phet.dischargelamps.quantum.model.ElectronSource;
import java.awt.geom.Point2D;

public class Plate
extends Electrode {
    private ElectronSource source;
    private ElectronSink sink;

    public Plate(BaseModel baseModel, ElectromotiveForce electromotiveForce, Point2D point2D, Point2D point2D2) {
        super(point2D, point2D2);
        this.source = new ElectronSource(electromotiveForce, point2D, point2D2, this);
        baseModel.addModelElement(this.source);
        this.sink = new ElectronSink(baseModel, point2D, point2D2);
        baseModel.addModelElement(this.sink);
    }

    public void setCurrent(double d) {
        this.source.setCurrent(d);
    }

    public ElectronSource getSource() {
        return this.source;
    }

    public void setEmittingLength(double d) {
        this.source.setLength(d);
    }

    public Electron produceElectron() {
        return this.source.produceElectron();
    }

    public void addElectronProductionListener(ElectronSource.ElectronProductionListener electronProductionListener) {
        this.source.addListener(electronProductionListener);
    }

    public void addElectronAbsorptionListener(ElectronSink.ElectronAbsorptionListener electronAbsorptionListener) {
        this.sink.addListener(electronAbsorptionListener);
    }
}

